package com.j3ltd.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import com.j3ltd.bean.PropertyBean;

public class StrutsProjectDao {
	public static List<PropertyBean> getPropertyList() {
		Properties systemProperties = System.getProperties();
		ArrayList propertyBeans = new ArrayList(systemProperties.size());
		for (Object aKey : systemProperties.keySet()) {
			Object aValue = systemProperties.get(aKey);
			PropertyBean aProperty = new PropertyBean();
			aProperty.setName(aKey.toString());
			aProperty.setValue(systemProperties.getProperty(aKey.toString()));
			propertyBeans.add(aProperty);
		}
		return propertyBeans;
	}
	
	public static PropertyBean getPropertyByName(String name) {
		Properties systemProperties = System.getProperties();
		PropertyBean aProperty = new PropertyBean();
		aProperty.setName(name);
		aProperty.setValue(systemProperties.getProperty(name));
		return aProperty;
	}
	
	public static void updateProperty(PropertyBean property) {
		System.setProperty(property.getName(), property.getValue());
	}
	
	public static void createProperty(PropertyBean property) {
		System.setProperty(property.getName(), property.getValue());
	}
	
	public static void deletePropertyByName(String propertyName) {
		System.clearProperty(propertyName);
	}
}
