package com.j3ltd.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;

import com.j3ltd.bean.EditPropertyViewItems;
import com.j3ltd.dao.StrutsProjectDao;
import com.j3ltd.forms.EditPropertyForm;

public class EditPropertyAction extends DispatchAction {
	private static final String FORWARD_VIEW = "view";
	private static final String FORWARD_DELETED = "deletedProperty";
	
	public ActionForward view(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) {
		String propertyName = request.getParameter("name");
		EditPropertyForm form = (EditPropertyForm) actionForm;
		if (propertyName != null) {
			setupViewItems(request, false);
			form.setFormPropertyBean(StrutsProjectDao.getPropertyByName(propertyName));
		}
		else {
			setupViewItems(request, true);
		}
		return mapping.findForward(FORWARD_VIEW);
	}
	
	public ActionForward update(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) {
		String propertyName = request.getParameter("name");
		EditPropertyForm form = (EditPropertyForm) actionForm;
		
		StrutsProjectDao.updateProperty(form.getFormPropertyBean());
		
		setupViewItems(request, false);
		ActionMessages messages = new ActionMessages();
		messages.add(ActionMessages.GLOBAL_MESSAGE,
				new ActionMessage("editPropertyStatusUpdateSaved"));
		super.saveMessages(request, messages);
		form.setFormPropertyBean(StrutsProjectDao.getPropertyByName(propertyName));
		return mapping.findForward(FORWARD_VIEW);
	}	
	
	public ActionForward create(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) {
		String propertyName = request.getParameter("name");
		EditPropertyForm form = (EditPropertyForm) actionForm;

		StrutsProjectDao.createProperty(form.getFormPropertyBean());
		
		setupViewItems(request, false);
		ActionMessages messages = new ActionMessages();
		messages.add(ActionMessages.GLOBAL_MESSAGE,
				new ActionMessage("editPropertyStatusCreateSaved"));
		super.saveMessages(request, messages);
		form.setFormPropertyBean(StrutsProjectDao.getPropertyByName(propertyName));
		return mapping.findForward(FORWARD_VIEW);
	}	
	
	public ActionForward delete(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) {
		String propertyName = request.getParameter("name");
		StrutsProjectDao.deletePropertyByName(propertyName);

		return mapping.findForward(FORWARD_DELETED);
	}	
	
	private void setupViewItems(HttpServletRequest request, boolean isNewProperty) {
		EditPropertyViewItems viewItems = new EditPropertyViewItems();
		viewItems.setNewProperty(isNewProperty);
		if (isNewProperty) {
			viewItems.setTitleKey("editPropertyTitleNew");
			viewItems.setHeadingKey("editPropertyTitleNew");
		}
		else {
			viewItems.setTitleKey("editPropertyTitleEdit");
			viewItems.setHeadingKey("editPropertyTitleEdit");
		}
		request.setAttribute("viewItems", viewItems);
	}
}

