package springtutorial;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main implements IMain {
	private String springWiredProperty;
	private IPrinter print;
	// Lists the files in which Spring beans are defined:
	private static final String[] SpringConfigLocations =
		{"mainSpringContext.xml"};
	
	public static void main(String[] args) {
		ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(SpringConfigLocations);
		IMain main = (IMain) context.getBean("mainApp");
		main.go();
	}

	@Override
	public void go() {
		print.print("It works " + springWiredProperty);
		
	}

	public String getSpringWiredProperty() {
		return springWiredProperty;
	}

	public void setSpringWiredProperty(String springWiredProperty) {
		this.springWiredProperty = springWiredProperty;
	}

	public IPrinter getPrint() {
		return print;
	}

	public void setPrint(IPrinter print) {
		this.print = print;
	}
	
	
}
