package springtutorial;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class Main implements IMain {
	private String springWiredProperty;
	private @Autowired @Qualifier("print") IPrinter print;
	private @Autowired ApplicationContext ctx;
	// Lists the files in which Spring beans are defined:
	private static final String[] SpringConfigLocations =
		{"mainSpringContext.xml"};
	
	public static void main(String[] args) {
		ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(SpringConfigLocations);
		IMain mainApp = (IMain) context.getBean("mainApp");
		mainApp.go();
	}

	@Override
	public void go() {
		print.print("It works " + springWiredProperty);
		print.print("a second line");
		
		IPrinter print2 = (IPrinter) ctx.getBean("print");
		print2.print("print from second printer bean");
	}

	public String getSpringWiredProperty() {
		return springWiredProperty;
	}

	public void setSpringWiredProperty(String springWiredProperty) {
		this.springWiredProperty = springWiredProperty;
	}
}
