package springtutorial;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class Main implements IMain {
	private String springWiredProperty;

	// Lists the files in which Spring beans are defined:
	private static final String[] SpringConfigLocations =
		{"mainSpringContext.xml"};
	
	public static void main(String[] args) {
		ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(SpringConfigLocations);
		IMain main = (IMain) context.getBean("mainApp");
		main.go();
	}

	@Override
	public void go() {
		IPrinter aPrinter = getPrint();
		aPrinter.print("It works " + springWiredProperty);
		aPrinter.print("a second line");
		
		IPrinter anotherPrinter = getPrint();
		anotherPrinter.print("this is printed from the second call to get the printer bean");	
	}

	public String getSpringWiredProperty() {
		return springWiredProperty;
	}

	public void setSpringWiredProperty(String springWiredProperty) {
		this.springWiredProperty = springWiredProperty;
	}

	public abstract IPrinter getPrint();
}
