package springtutorial;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@PropertySource("classpath:SpringConsole.properties")
@ComponentScan("springtutorial")
public class SpringConfig {
	private @Autowired ApplicationContext ctx;
	@Value("${printer}")
	private String printerBeanName = "";
	
	@Bean
	@Scope("${printer.scope}") 
	public IPrinter print() {
	
		return (IPrinter) ctx.getBean(printerBeanName);
	}
	
	@Bean
	public IMain mainApp() {
		Main main = ctx.getBean(Main.class);
		main.setSpringWiredProperty("value set in SpringConfig");
		return main;
	}

    @Bean 
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() { 
        return new PropertySourcesPlaceholderConfigurer(); 
    } 
    
}
