package com.j3ltd.test.web;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.naming.*;
import java.io.*;
import java.util.*;

import com.j3ltd.test.ejbs.*;

public class TestStatelessEJBServlet extends HttpServlet {
	private TestStateless statelessBean;
	
	public void init() throws ServletException {
		try {
			Context context = new InitialContext();
			statelessBean = (TestStateless) context.lookup("TestStatelessBean/remote");
					//TestStateless.class.getName());
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void doPost(HttpServletRequest req, HttpServletResponse resp) 
	                   throws ServletException, IOException {
		doGet(req, resp);
	}
	
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
	                  throws ServletException, IOException {
		PrintWriter writer = resp.getWriter();
		writer.write("The stateless bean returned this string: " + 
				     statelessBean.testBean() + "\n");
		
		List<Person> people = statelessBean.getAllPersons();
		for (Person person : people) {
			writer.write("Email retrieved: " + person.getEmail() + "\n");
		}
		
	}
}
