package com.j3ltd.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.j3ltd.server.ejb.*;

public class RelationshipServlet  extends HttpServlet {
	private StatelessEJB statelessBean;
	
	public void init() throws ServletException {
		try {
			Context context = new InitialContext();
			statelessBean = (StatelessEJB) context.lookup("StatelessEJBBean/remote");
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}
	
	public void doPost(HttpServletRequest req, HttpServletResponse resp) 
	                   throws ServletException, IOException {
		doGet(req, resp);
	}
	
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
	                  throws ServletException, IOException {
		PrintWriter writer = resp.getWriter();
		writer.write("Create test data...");
		statelessBean.createTestData();
		writer.write("done\n\n");
		displayPeople(resp);
		displayHomes(resp);
		writer.write("\nDelete some data...");
		statelessBean.deleteSomeData();		
		writer.write("done\n\n");
		displayPeople(resp);
		displayHomes(resp);	
	}
	
	private void displayPeople(HttpServletResponse resp) throws IOException {
		PrintWriter writer = resp.getWriter();
		writer.write("List of Person ejbs:\n");
		List<Person> people = statelessBean.getAllPersons();
		for (Person person : people) {
			writer.write("Person retrieved: " + person.getName() + "\n");
			List<UserRole> roles = statelessBean.getPersonRoles(person);
			if (roles != null) {
				writer.write("   role: ");
				for (UserRole role : roles) {
					writer.write(role.getRole().getRoleName() + " ");
				}
				writer.write("\n");
			}
			List<Home> homes = statelessBean.getPersonHomes(person);
			if (homes != null) {
				for (Home home : homes) {
					writer.write("   Home: " + home.getStreetAddress() + "\n");
				}
			}
		}		
	}
	
	private void displayHomes(HttpServletResponse resp) throws IOException {	
		PrintWriter writer = resp.getWriter();
		writer.write("\nList of Home ejbs:\n");
		List<Home> homes = statelessBean.getAllHomes();
		for (Home home : homes) {
			writer.write("Home retrieved: " + home.getStreetAddress() + "\n");
			List<Person> people = statelessBean.getHomePersons(home);
			if (people != null) {
				for (Person person : people) {
					writer.write("   Person: " + person.getName() + "\n");
					List<UserRole> roles = statelessBean.getPersonRoles(person);
					if (roles != null) {
						writer.write("      role: ");
						for (UserRole role : roles) {
							writer.write(role.getRole().getRoleName() + " ");
						}
						writer.write("\n");
					}					
				}
			}
		}		
	}
}
