package com.j3ltd.server.ejb;

import java.io.Serializable;
import javax.persistence.*;

@Entity
public class UserRole implements Serializable {
	static final long serialVersionUID = 1;
	
	private int id;
	private Role role;
	private Person person;
	
	public UserRole() {
		
	}
	
	public UserRole(Role role) {
		this.role = role;
	}
	
	@ManyToOne
	public Person getPerson() {
		return person;
	}
	public void setPerson(Person person) {
		this.person = person;
	}
	
	@Id
	@GeneratedValue
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	
	@ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
	@JoinColumn(name="roleName", 
		    referencedColumnName="roleName")
	public Role getRole() {
		return role;
	}
	public void setRole(Role role) {
		this.role = role;
	}
	

}
