package com.j3ltd.server.ejb;

import javax.ejb.*;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import java.util.*;

@Stateless public class StatelessEJBBean implements StatelessEJB {
	@PersistenceContext(unitName="EJBRelationshipsPU") EntityManager em;
	
	public List<Person> getAllPersons() {
		ArrayList<Person> toReturn = new ArrayList<Person>();
		Query q = em.createNamedQuery("findPersonAll"); 
		for (Object po : q.getResultList()) {
			toReturn.add((Person) po);
		}
		return toReturn;
	}
	
	public List<Home> getAllHomes() {
		ArrayList<Home> toReturn = new ArrayList<Home>();
		Query q = em.createNamedQuery("findHomeAll");
		for (Object ho : q.getResultList()) {
			toReturn.add((Home) ho);
		}
		return toReturn;
	}
	
	/**
	 * Client can't call getHomes() on person, as it's detached &
	 * lazilly fetched
	 */
	public List<Home> getPersonHomes(Person person) {
		em.refresh(person);
		List<Home> homes = person.getHomes();
		ArrayList<Home> toReturn = new ArrayList<Home>(homes.size());
		for (Home home : homes) {
			toReturn.add(home);
		}
		return toReturn;
	}
	/**
	 * Client can't call getPersons() on home, as it's detached &
	 * lazilly fetched
	 */	
	public List<Person> getHomePersons(Home home) {
		em.refresh(home);
		List<Person> persons = home.getPersons();
		ArrayList<Person> toReturn = new ArrayList<Person>(persons.size());
		for (Person person : persons) {
			toReturn.add(person);
		}
		return toReturn;
	}
	
	public List<UserRole> getPersonRoles(Person person) {
		em.refresh(person);
		List<UserRole> roles = person.getUserRoles();
		ArrayList<UserRole> toReturn = new ArrayList<UserRole>(roles.size());
		for (UserRole role : roles) {
			toReturn.add(role);
		}
		return toReturn;		
	}
	
	public void createTestData() {
		
		// Create the role entities
		Role pm = new Role();
		pm.setRoleName("pm");
		pm.setRoleDescription(("Prime Minister"));
		em.persist(pm);
		
		Role pres = new Role();
		pres.setRoleName("pres");
		pres.setRoleDescription("President");
		em.persist(pres);
		
		Role vp = new Role();
		vp.setRoleName("vp");
		vp.setRoleDescription("Vice President");
		em.persist(vp);
		
		// create home 10 downing street 
		Home home = new Home();
		home.setStreetAddress("10 Downing Street");
		em.persist(home);
		// need to refresh otherwise home.addPerson() fails: 
		// persons List member is null.
		em.refresh(home);
		
		// create mr blair
		Person person = new Person();
		person.setName("Mr Blair");
		em.persist(person);
		// add user role pm
		UserRole userRole = new UserRole(pm);
		em.persist(userRole);
		em.refresh(person);
		person.addUserRole(userRole);
		// add user role pres
		userRole = new UserRole(pres);
		em.persist(userRole);
		person.addUserRole(userRole);
		home.addPerson(person);
		
		// create Mr Brown
		person = new Person();
		person.setName("Mr Brown");
		em.persist(person);	
		em.refresh(person);
		home.addPerson(person);
		// add user role vp
		userRole = new UserRole(vp);
		em.persist(userRole);
		person.addUserRole(userRole);
		
		// create 11 downing street
		home = new Home();
		home.setStreetAddress("11 Downing Street");
		em.persist(home);
		em.refresh(home);
		// add current person Mr Brown
		home.addPerson(person);
		
		// create whitehouse
		home = new Home();
		home.setStreetAddress("Whitehouse, Washington DC");
		em.persist(home);
		em.refresh(home);
		// add Mr Bush
		person = new Person();
		person.setName("Mr Bush");
		em.persist(person);
		em.refresh(person);
		// Add user role pres
		userRole = new UserRole(pres);
		em.persist(userRole);
		person.addUserRole(userRole);
		home.addPerson(person);
		// create mr Cheney
		person = new Person();
		person.setName("Mr Cheney");
		em.persist(person);	
		em.refresh(person);
		// add user role vp
		userRole = new UserRole(vp);
		em.persist(userRole);
		person.addUserRole(userRole);
		home.addPerson(person);
		
		// create lise Palace
		home = new Home();
		home.setStreetAddress("lise Palace");
		em.persist(home);
		em.refresh(home);
		// create Mr Chirac
		person = new Person();
		person.setName("Mr Chirac");
		em.persist(person);
		em.refresh(person);
		// add user role pres
		userRole = new UserRole(pres);
		em.persist(userRole);
		person.addUserRole(userRole);
		home.addPerson(person);
	}
	
	public void deleteSomeData() {
		
		// remove 11 downing street
		Query q = em.createNamedQuery("findHomeByStreetAddress");
		q.setParameter("streetAddress", "11 Downing Street");
		List list = q.getResultList();
		for (Object home : list) {
			em.remove(home);
		}
		
		// remove Mr blair
		q = em.createNamedQuery("findPersonByName");
		q.setParameter("name", "Mr Blair");
		list = q.getResultList();
		for (Object person : list) {
			removePerson((Person)person);
		}   
		
		// remove Mr Chirac
		q.setParameter("name", "Mr Chirac");
		list = q.getResultList();
		for (Object person : list) {
			removePerson((Person)person);
		}
	}
	
	/**
	 * To remove a Person record, the person must be removed from
	 * all the homes first. Otherwise a foreign key constraint
	 * is thrown when removing the person.
	 *  
	 * @param toRemove the person to remove.
	 */
	private void removePerson(Person toRemove) {
		List<Home> homes = toRemove.getHomes();
		for (Home home : homes) {
			home.dropPerson(toRemove);
		}
		em.remove(toRemove);
	}
}
