package com.j3ltd.server.ejb;

import java.io.Serializable;

import javax.persistence.*;

import java.util.*;

@Entity
@NamedQueries({
	@NamedQuery(name="findPersonAll", query="SELECT o FROM Person o"),
	@NamedQuery(name="findPersonByName", query="SELECT o FROM Person o WHERE o.name = :name")
})
public class Person implements Serializable {
	static final long serialVersionUID = 2;
	
	private String name;
	private int id;
	private List<Home> homes;
	private List<UserRole> userRoles;
	
	@ManyToMany(mappedBy="persons") 
	protected List<Home> getHomes() {
		return homes;
	}
	
	protected void setHomes(List<Home> homes) {
		this.homes = homes;
	}
	
	@OneToMany(cascade=CascadeType.ALL, mappedBy="person")
	public List<UserRole> getUserRoles() {
		return userRoles;
	}

	public void setUserRoles(List<UserRole> userRoles) {
		this.userRoles = userRoles;
	}
	
	public void addUserRole(UserRole userRole) {
		this.getUserRoles().add(userRole);
		userRole.setPerson(this);
	}

	@Id
	@GeneratedValue
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	

}
