package com.j3ltd.server.ejb;

import java.io.Serializable;
import javax.persistence.*;

import java.util.*;

@Entity
@NamedQueries({
	@NamedQuery(name="findHomeAll", query="SELECT o FROM Home o"),
	@NamedQuery(name="findHomeByStreetAddress", 
			query="SELECT o FROM Home o WHERE o.streetAddress = :streetAddress")
})
public class Home implements Serializable {
	static final long serialVersionUID = 1;	
	
	private int id;
	private String streetAddress;
	private List<Person> persons;
	
	@Id
	@GeneratedValue
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getStreetAddress() {
		return streetAddress;
	}
	public void setStreetAddress(String streetAddress) {
		this.streetAddress = streetAddress;
	}
	
	@ManyToMany
	@JoinTable(name="HomePersons", 
	  joinColumns=
        @JoinColumn(name="homeId", referencedColumnName="id"),
      inverseJoinColumns=
    	@JoinColumn(name="personId", referencedColumnName="id")
      )
	public List<Person> getPersons() {
		return persons;
	}
	public void setPersons(List<Person> persons) {
		this.persons = persons;
	}
	public void addPerson(Person toAdd) {
		this.getPersons().add(toAdd);
	}
	public void dropPerson(Person toDrop) {
		this.getPersons().remove(toDrop);
	}
}
