package com.j3ltd.java15changes;

import java.util.*;

class GenericEg1<G> {
  G genericMember;

  public GenericEg1(G param) {
    genericMember = param;
  }

  public G getMe() {
    return genericMember;
  }
}

class GenericEg2<G extends Number> {
	  G genericMember;

	  public GenericEg2(G param) {
	    genericMember = param;
	  }

	  public G getMe() {
	    return genericMember;
	  }
	  
	  public double sum(List<? extends Number> list) {
		  double toReturn = 0.0;
		  for (Number number : list) {
			  toReturn += number.doubleValue();
		  }
		  return toReturn;
	  }
	}

public class Generics {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		// Demo GenericEg1 class
		GenericEg1<Integer> eg1;
		eg1 = new GenericEg1<Integer>(100);
		int itIs = eg1.getMe();
		System.out.println("GenericEg1 itIs: " + itIs + '\n');
		
		// Demo GenericEg2 class
		GenericEg2<Float> eg2;
		eg2 = new GenericEg2<Float>(10.2f);
		List<Integer> aList = new ArrayList<Integer>();
		aList.add(1);
		aList.add(2);
		aList.add(3);
		double sum = eg2.sum(aList);
		System.out.println("GenericEg2 sum is " + sum + '\n');
	}

}
