package com.j3ltd.java15changes;

import java.lang.annotation.*;

enum ReleaseType {alpha, beta, production };

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@interface ClassVersion {
	String author();
	int majorVersion() default 1;
	int minorVersion() default 0;
	ReleaseType release() default ReleaseType.alpha;
}

@ClassVersion(author = "Fred", release = ReleaseType.production)
public class AnnotationExample {

	public static void main(String[] args) {
		AnnotationExample eg = new AnnotationExample();
		ClassVersion version =  eg.getClass().getAnnotation(ClassVersion.class);
		System.out.println("AnnotationExample by " + version.author() +
				" Version " + version.majorVersion() + '.' + 
				version.minorVersion() + ' ' + version.release() + " release");	
	}
}
